---
generated_at: 2026-02-02 10:01:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：2-CronJob Controller バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **StartingDeadlineSecondsの詳細挙動**：syncCronJob内の詳細ロジックは別ファイルに存在する可能性
  2. **メトリクス名の正確性**：具体的なメトリクス名はmetrics/パッケージの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/cronjob/cronjob_controllerv2.go` - ControllerV2構造体定義（L63-L81）
- E-02: `pkg/controller/cronjob/cronjob_controllerv2.go` - NewControllerV2関数（L84-L131）
- E-03: `pkg/controller/cronjob/cronjob_controllerv2.go` - Run関数（L134-L162）
- E-04: `pkg/controller/cronjob/cronjob_controllerv2.go` - sync関数（L188-L235）
- E-05: `pkg/controller/cronjob/cronjob_controllerv2.go` - nextScheduleDelta定数（L58）
- E-06: `pkg/controller/cronjob/cronjob_controllerv2.go` - updateCronJob関数（L386-L399）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - No.2 エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ControllerV2がqueue, kubeClient, recorder等を保持 | E-01 | ○ |
| C-02 | DelayingQueueとInformerを使用するV2実装 | E-01, E-02 | ○ |
| C-03 | nextScheduleDelta = 100ms | E-05 | ○ |
| C-04 | Job/CronJobのInformerハンドラを登録 | E-02 | ○ |
| C-05 | Run関数でキャッシュ同期後にワーカー起動 | E-03 | ○ |
| C-06 | sync関数でCronJob取得→Job一覧取得→cleanup→syncCronJob | E-04 | ○ |
| C-07 | CronJob NotFoundの場合はnilを返却 | E-04 | ○ |
| C-08 | requeueAfterで次回スケジュール再投入 | E-04 | ○ |
| C-09 | updateCronJobでスケジュール/タイムゾーン変更を検知 | E-06 | ○ |
| C-10 | getJobsToBeReconciledでControllerRefベースのJob取得 | E-04 | ○ |
| C-11 | cronJobControlによるステータス更新 | E-04 | ○ |
| C-12 | controllerKind = batch/v1 CronJob | E-01 | ○ |
| C-13 | メトリクス登録実行 | E-02 | ○ |
| C-14 | EventBroadcasterによるイベント記録 | E-02, E-03 | ○ |
| C-15 | processNextWorkItemでキー処理とリキュー | E-01 | ○ |
| C-16 | ConcurrencyPolicyの制御 | E-07 | ○ |
| C-17 | SuccessfulJobsHistoryLimit/FailedJobsHistoryLimitの管理 | E-07 | ○ |
| C-18 | parsers.ParseCronScheduleWithPanicRecoveryの使用 | E-06 | ○ |
| C-19 | StartingDeadlineSecondsの詳細挙動 | **根拠なし** | △ |
| C-20 | 具体的なメトリクス名 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- syncCronJob関数の詳細ロジック（スケジュール判定、Job作成の具体的な手順）は別のヘルパー関数に分散している可能性がある。
  - 候補：`pkg/controller/cronjob/cronjob_controllerv2.go` の残りの部分 / `utils.go`
- メトリクスの具体的な名称と定義は `pkg/controller/cronjob/metrics/` パッケージの確認が必要。
  - 候補：`pkg/controller/cronjob/metrics/metrics.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ControllerV2構造体とRun/sync処理フローの記述は正確
- 1: 中リスク - syncCronJob内部の詳細ロジックの完全性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] ControllerV2構造体のフィールドがソースコードと一致しているか確認
- [ ] sync処理フロー（cleanup→syncCronJob→status update）の順序が正しいか確認
- [ ] ConcurrencyPolicy（Allow/Forbid/Replace）の挙動が正確に記述されているか確認
- [ ] メトリクス名が実際の登録と一致しているか確認
